#include <stdio.h>
#include <stdlib.h>

unsigned char data[8];
unsigned char encoded[8];
unsigned char key[24];
unsigned int counter = 0;
unsigned int keycounter = 0;

unsigned char mainkey[24] = {0x00, 0xff, 0xff, 0xff,  0xa0, 0xa0, 0xff, 0xff,
			    0xff, 0xff, 0xff, 0x00,  0xff, 0xff, 0x00, 0xa0,
			    0xff, 0xa0, 0x00, 0xff,  0xff, 0xff, 0xff, 0xff};

unsigned int map[8] = {3, 2, 5, 7, 0, 6, 1, 4};

// Rotate 64-bits left around the 192-bit key
void rotatekey() {
	unsigned char temp[8];
	int x;

	for (x = 0; x < 8; x++) {
		temp[x] = key[x];
	}
	for (x = 0; x < 16; x++) {
		key[x] = key[x+8];
	}
	for (x = 0; x < 8; x++) {
		key[x+16] = temp[x];
	}

	keycounter++;
}

void resetkey() {
	int x;

	// Set the key back to the initial key and reset the key counter
	for (x = 0; x < 24; x++) {
		key[x] = mainkey[x];
	}

	keycounter = 0;
}

void xencode() {	
	unsigned int x, y;
	unsigned char temp;

	// XOR 8 bytes of data with 8 bytes of the kye
	for (x = 0; x < 8; x++) {
		data[x] = data[x] ^ key[x];

		// If the key byte is 0x00 flip the byte 
		if (key[x] == 0x00) {
			temp = 0x00;
			temp |= (data[x] << 4);
			temp |= (data[x] >> 4);
			data[x] = temp;
		}
	}

	// Permute the encoded data with map
	for (x = 0; x < 8; x++) {
		encoded[map[x]] = data[x];
	}

	// Set data to the encoded data
	for (x = 0; x < 8; x++) {
		data[x] = encoded[x];
	}
}

int encodefile(char *in, char *out) {
	FILE *f, *g;
	int read, x, y;

	// Initial key set
	resetkey();

	f = fopen(in, "rb");
	g = fopen(out, "wb");

	if (f == NULL) {
		printf("Unable to open the input file.\n");
		return 1;
	}
	if (g == NULL) {
		printf("Unable to open the output file.\n");
		return 1;
	}

	// Write 00 byte to output file (required for booting)
	fwrite("", 1, 1, g);

	while (read = fread(data, 1, 8, f)) {
		// Read 8 bytes at a time
		//read = fread(data, 1, 8, f);

		// If 8 bytes weren't read, pad out to 8 bytes with 0s
		if (8 - read) {
			for (x = read; x < 8; x++) {
				data[x] = 0xFF;
			}
		}

		// Encode the 8 bytes 15 times
		for (x = 0; x < 15; x++) {
			xencode();
		}

		// If 1024 bytes have been encoded, reset the key to the initial
		(keycounter == 127) ? resetkey() : rotatekey();

		// Write the data to the output file
		fwrite(data, 1, 8, g);
	}

	fclose(f);
	fclose(g);

	return 0;
}


int main(int argc, char **argv) {
	if (argc == 3) {
		return encodefile(argv[1], argv[2]);
	}
	else {
		printf("Use: %s <input-file> <output-file>", argv[0]);
		return 1;
	}
}

