#include <windows.h>
#include <string.h>
#include <stdio.h>

#define BOOTLABEL "BOOTDISK"

// code for Borland C++ 5.5 free

int ReadBootSector(int drive)
    {
    char buffer[512];
    HANDLE hDevice ;
    DWORD bytesread;
    int res;
    char _devicename[] = "\\\\.\\A:";

    _devicename[4] += drive;
    hDevice = CreateFile(_devicename,  GENERIC_READ|GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);

    if (hDevice == INVALID_HANDLE_VALUE)  return 0;

    SetFilePointer (hDevice, 0, NULL, FILE_BEGIN);

    if (!ReadFile (hDevice, &buffer, 512, &bytesread, NULL) ) 
        { 
        printf("error: cannot read boot sector\n");  
        res= 0;
        }
    else 
        {
        res = !strncmp(buffer+0x40, BOOTLABEL, strlen(BOOTLABEL)) ? 2 : 1 ;
        }
        
    CloseHandle(hDevice);
    return res;
    }
    
int ModifyBootSector(int drive)
    {
    char buffer[512];
    HANDLE hDevice ;
    DWORD bytesread;
    int res=1;
    char _devicename[] = "\\\\.\\A:";

    _devicename[4] += drive;
    hDevice = CreateFile(_devicename,  GENERIC_READ|GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);

    if (hDevice == INVALID_HANDLE_VALUE)  return 0;

    SetFilePointer (hDevice, 0, NULL, FILE_BEGIN);

    if (!ReadFile (hDevice, &buffer, 512, &bytesread, NULL) ) 
        { 
        printf("error: cannot read boot sector\n");  
        res= 0;
        }
    else 
        {
        memcpy(buffer+0x40, BOOTLABEL, strlen(BOOTLABEL));
        SetFilePointer (hDevice, 0, NULL, FILE_BEGIN);
        if (!WriteFile (hDevice, &buffer, 512, &bytesread, NULL) )  
            {
            printf("error: cannot write boot sector\n");
            res= 0;
            }
        }

    CloseHandle(hDevice);
    return res;
    }

int main(int argc, char **argv)
    {
    int drive, read, errcode=2;
    char c;
    
    if ((argc!=2) || (argv[1][1]!=':') || !isalpha(argv[1][0])) 
        {
        printf("usage: bootable.exe <drive:>\n");
        errcode = 1;
        }
    else
        {
        drive=toupper(argv[1][0])-'A';
 
        printf("(R)ead or (W)rite ? ");
        c=getchar();
    
        if (toupper(c)=='W')  errcode = ModifyBootSector(drive) ? 0 : 3;
        if (toupper(c)=='R') 
            {
            read = ReadBootSector(drive);
            if(read==2) { printf("'BOOTDISK' found at 0x40\n"); errcode = 4; }
            if(read==1) { printf("'BOOTDISK' NOT found!\n"); errcode = 5; }
            if(read==0) errcode=3;
            }
        }
        
    printf("return value = %d", errcode);
    return errcode;
    }
