#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=CHDKLOGO3.ico
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_Res_Comment=SD Card Utility for Canon P&S cameras with CHDK
#AutoIt3Wrapper_Res_Description=CardTricks
#AutoIt3Wrapper_Res_Fileversion=1.4.5.0
#AutoIt3Wrapper_Res_LegalCopyright=GPLv2
#AutoIt3Wrapper_Res_requestedExecutionLevel=asInvoker
#AutoIt3Wrapper_Res_Field="Language"|"AutoIt 3.2.12.1"
#AutoIt3Wrapper_Res_Field="Built by"|"whim"
#AutoIt3Wrapper_Run_After=upx --ultra-brute %out%
#AutoIt3Wrapper_Run_Obfuscator=y
#Obfuscator_Parameters=/striponly
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#include "GUIConstantsEx.au3"

Opt("MustDeclareVars", 1)
Opt("TrayIconHide", 1)
Opt("WinTitleMatchMode", 2)

Global Const $Title = "CardTricks v1.45"
Global Const $tt = "About ..."
Global Const $ud_tip =	"Create Udumper Card for this camera type" & @CRLF & _
						"Allows max 4, but warns > 2 GB card size"
Global Const $ud_txt = 	"~~~~~~~~~~~~~~~~ Important info about Universal Dumper ~~~~~~~~~~~~~~~~" & @CRLF & @CRLF & _
						"You CAN NOT SEE IF IT WORKS, it gives NO VISUAL OR SOUND FEEDBACK WHILE RUNNING !" & @CRLF & _
						"If the screen comes up with 'Card Locked', then remove & put back the batteries" & @CRLF & _
						"and try again several times before giving up" & @CRLF & @CRLF & _
						"================= How to DUMP CAMERA FIRMWARE =================" & @CRLF & @CRLF & _
						"     1) Prepare the card, write protect it & insert in camera" & @CRLF & _
						"     2) assure camera is in play (not shoot) mode" & @CRLF & _
						"     3) start camera and wait at least 30 seconds" & @CRLF & _
						"     4) remove first batteries, then the card from the camera" & @CRLF & _
						"     5) re-insert the batteries in camera." & @CRLF & @CRLF & _
						"=================== How to CHECK YOUR DUMP ===================" & @CRLF & @CRLF & _
						"     1) Insert the card with your dump in the card reader" & @CRLF & _
						"     2) start this program and select your card" & @CRLF & _
						"     3) press 'Strings'; if there's any readable material shown, your dump is probably OK." & @CRLF & _
						"          Pressing 'Clean' will strip leading and trailing zero bytes, and copy the result" & @CRLF & _
						"          to the CardTricks directory. It should then be ready for porting to CHDK." & @CRLF & _
						"     4) If it failed, try again, or try other versions of the dumper."
Global $here, $inifile, $subdir
Global $mbut_mkboot, $mbut_form_fat, $mbut_down_bin, $mbut_copy_bin, $mbut_copy_2cust, $mbut_copy_2card
Global $mbut_sel_cust, $mbut_chdk_cfg, $mbut_chdk_show, $mbut_resizer
Global $chk_bin_over, $chk_cust_over, $chk_fix_disk, $chk_stop_info, $chk_auto_sel, $chk_notooltips, $chk_CF
Global $mbut_udump_dry, $mbut_udump_newdry, $mbut_udump_vxw, $mbut_udump_show, $mbut_udump_analyse
Global $mbut_show, $mbut_go_back, $mbut_credits
Global $cmsg, $ret, $dummy, $flag, $cardmenu, $card_drive, $card_pic, $bins, $redraw
Global $bootstate, $bootstateCF, $bootstateCF32
Global $card_fs = "", $card_sz, $custom_path
Global $lab_card_drv, $lab_card_typ, $lab_card_fs, $lab_card_lab, $lab_card_siz, $lab_card_boot, $lab_cust_path
Global $illegal = StringLeft(@HomeDrive,1) & StringLeft(@SystemDir, 1) & StringLeft($here, 1)
Global $acceptable
Global $wpos[4] = [-1, -1, -1, -1]
Global $f_small, $f_normal, $f_scaler, $w_scaler, $w_sticky
Global $last_copy_path

If WinExists($Title) Then
	WinActivate($Title)
	Exit
EndIf

$here = @ScriptDir	; If, and only if, ScriptDir is root it has a trailing '\' ...
If StringRight(@ScriptDir, 1) = "\" Then $here = StringTrimRight(@ScriptDir, 1)
$inifile = StringTrimRight($here & "\" & @ScriptName, 3) & "ini"
$subdir = $here & "\CardTricks"
; --------------------------------------------------------
$f_scaler = IniRead($inifile, "Program", "fscale", 1)
$w_scaler = IniRead($inifile, "Program", "wscale", 1)
$w_sticky = IniRead($inifile, "Program", "chk_sticky", 1)

ReadXY()

SplashOff()

ShowCardMenu()
Exit

; --------------------------------------------------------
; -------- Program End, Begin of Functions ---------------
; --------------------------------------------------------

; ---------------------------------------- Helper Functions -----------------------------------------------------------------------
Func R($size)
	Return Round($w_scaler * $size)
EndFunc
; --------------------------------------------
Func IsChecked($control)
	If BitAND( GUICtrlRead($control), $GUI_CHECKED ) = $GUI_CHECKED Then Return 1
	Return 0
EndFunc
; --------------------------------------------
Func SetSize()
	Local $sizer, $inp_ws, $upd_ws, $inp_fs, $upd_fs, $but_apply, $but_cancel, $chk_sticky, $s_msg

	$sizer = GUICreate("Adapt Font and Window", 250, 130, $wpos[0]+100, $wpos[1]+100, 0x80C00000)
	GUICtrlCreateLabel("Scale Window size to ", 15, 10, 105, 20)
	$inp_ws = GUICtrlCreateInput(String($w_scaler*100), 125, 7, 50, 20 )
	$upd_ws = GUICtrlCreateUpdown($inp_ws, 0x20)
	GUICtrlSetLimit(-1, 200, 70)	; set min / max recheck periods here
	GUICtrlCreateLabel("% of original", 180, 10, 70, 20 )
	GUICtrlCreateLabel("Scale Font size to ", 15, 40, 105, 20 )
	$inp_fs = GUICtrlCreateInput(String($f_scaler*100), 125, 37, 50, 20 )
	$upd_fs = GUICtrlCreateUpdown($inp_fs, 0x20)
	GUICtrlSetLimit(-1, 200, 70)	; set min / max recheck periods here
	GUICtrlCreateLabel("% of original", 180, 40, 70, 20 )
	$chk_sticky = GUICtrlCreateCheckbox("Sticky Window (remember window position)", 15, 70)
	If $w_sticky = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)
	If $w_sticky = 0 Then GUICtrlSetState(-1, $GUI_UNCHECKED)

	$but_apply = GUICtrlCreateButton("OK", 10, 100, 110, 20 )
	$but_cancel = GUICtrlCreateButton("Cancel", 130, 100, 110, 20 )
	GUISetState(@SW_SHOW, $sizer)
	While 1
		$s_msg = GUIGetMsg()
		Switch $s_msg
			Case $but_cancel
				ExitLoop
			Case $but_apply
				$w_scaler = GUICtrlRead($inp_ws) / 100.0
				IniWrite($inifile, "Program", "wscale", $w_scaler)
				$f_scaler = GUICtrlRead($inp_fs) / 100.0
				IniWrite($inifile, "Program", "fscale", $f_scaler)
				If IsChecked($chk_sticky) Then
					$w_sticky = 1
				Else
					$w_sticky = 0
				EndIf
				IniWrite($inifile, "Program", "chk_sticky", $w_sticky)
				ExitLoop
		EndSwitch
	WEnd
	GUIDelete($sizer)
EndFunc
; --------------------------------------------
Func ReadXY()
	$wpos[0] = IniRead($inifile, "Program", "w_x", -1)
	$wpos[1] = IniRead($inifile, "Program", "w_y", -1)
EndFunc
; --------------------------------------------
Func WriteXY()
	$wpos = WinGetPos($cardmenu)
	IniWrite($inifile, "Program", "w_x", $wpos[0])
	IniWrite($inifile, "Program", "w_y", $wpos[1])
EndFunc
; --------------------------------------------
Func DosExec($cmdline, $wd = $here, $mode = @SW_MINIMIZE)
	Local $ret
	$ret = RunWait(@ComSpec & " /c " & $cmdline, $wd, $mode)
	Return $ret
EndFunc
; --------------------------------------------
Func ReadSett($control, $section, $name, $default = 0)
	If IniRead($inifile, $section, $name, $default) = 1 Then
		GUICtrlSetState($control, $GUI_CHECKED)
	Else
		GUICtrlSetState($control, $GUI_UNCHECKED)
    EndIf
EndFunc
; --------------------------------------------
Func SaveSett($control, $section, $name)
	If IsChecked($control) Then
		IniWrite($inifile, $section, $name, 1)
	Else
		IniWrite($inifile, $section, $name, 0)
    EndIf
EndFunc

; ---------------------------------------- Card related functions -----------------------------------------------------------------

Func ShowCardMenu()

	$f_small  = 7.0 * $f_scaler
	$f_normal = 8.5 * $f_scaler

	If WinExists($cardmenu) Then GUIDelete($cardmenu)

	If $w_sticky = 0 Then
		$wpos[0] = -1
		$wpos[1] = -1
	EndIf

	$cardmenu = GUICreate ( $Title, R(550), R(320), $wpos[0], $wpos[1])
	GUISetFont($f_normal, 400, 1, "Tahoma")
	; -------------------------------------------------------------------------------
	GUICtrlCreateGroup(" Card Info && Selection", R(20), R(20), R(250), R(180) )
	$chk_auto_sel = GUICtrlCreateCheckbox("Auto", R(225), R(20), R(40), R(18) )
	GUICtrlSetFont(-1, $f_small)
	GUICtrlCreateLabel( "Selected Drive: ", R(30), R(50) )
	$lab_card_drv = GUICtrlCreateLabel( "", R(110), R(50), R(30), R(20) )
	GUICtrlCreateLabel( "Drive Type:", R(30), R(70) )
	$lab_card_typ = GUICtrlCreateLabel( "", R(110), R(70), R(60), R(20) )
	GUICtrlCreateLabel( "File System:", R(30), R(90) )
	$lab_card_fs = GUICtrlCreateLabel( "", R(110), R(90), R(40), R(20) )
	GUICtrlCreateLabel( "Drive Label:", R(30), R(110) )
	$lab_card_lab = GUICtrlCreateLabel( "", R(110), R(110), R(120), R(20) )
	GUICtrlCreateLabel( "Card Size: ", R(30), R(130) )
	$lab_card_siz = GUICtrlCreateLabel( "", R(110), R(130), R(155), R(20) )
	GUICtrlCreateLabel( "CHDK Autorun: ", R(30), R(150) )
	$lab_card_boot = GUICtrlCreateLabel( "" , R(110), R(150), R(155), R(20) )
	GUICtrlCreateLabel( "Select >>" , R(175), R(52), R(55), R(14) )
	GUICtrlSetFont(-1, $f_small)
	$card_pic = GUICtrlCreateIcon($subdir & "\card2.ico", -1, R(225), R(43), R(33), R(43), -1)
	$mbut_show = GUICtrlCreateButton("Show", R(225), R(91), R(35), R(22) )
	GUICtrlSetState(-1, $GUI_DISABLE)
	GUICtrlSetFont(-1, $f_small)
	$mbut_form_fat = GUICtrlCreateButton("Format as FAT", R(30), R(170), R(115), R(22) )
	GUICtrlSetState(-1, $GUI_DISABLE)
	$mbut_mkboot = GUICtrlCreateButton("Make Bootable", R(150), R(170), R(110), R(22) )
	GUICtrlSetState(-1, $GUI_DISABLE)
	; -----------------------------------------------------------------------------
	GUICtrlCreateGroup(" Create/Inspect Universal Dumper Card", R(20), R(210), R(250), R(95) )
	GUICtrlCreateLabel("Formats, so DELETES ALL DATA on the card !", R(40), R(230), -1, R(14) )
	GUICtrlSetColor(-1, 0xFF0000)
	$mbut_udump_newdry = GUICtrlCreateButton("NewDryOS", R(30), R(245), R(70), R(22) )
	GUICtrlSetState(-1, $GUI_DISABLE)
	$mbut_udump_dry = GUICtrlCreateButton("DryOS", R(105), R(245), R(75), R(22) )
	GUICtrlSetState(-1, $GUI_DISABLE)
	$mbut_udump_vxw = GUICtrlCreateButton("VxWorks", R(185), R(245), R(75), R(22) )
	GUICtrlSetState(-1, $GUI_DISABLE)
	GUICtrlCreateLabel("AFTER dumping -->", R(40), R(280), R(100), R(20) )
	$mbut_udump_show = GUICtrlCreateButton("Strings", R(140), R(275), R(60), R(22) )
	GUICtrlSetState(-1, $GUI_DISABLE)
	$mbut_udump_analyse = GUICtrlCreateButton("Clean", R(205), R(275), R(55), R(22) )
	GUICtrlSetState(-1, $GUI_DISABLE)
	; ------------------------------------------------------------------------------
	; -------resizer button---------------------------------------------------------
	$mbut_resizer = GUICtrlCreateButton("GUI Config ...", R(460), R(5), R(70), R(18) )
	GUICtrlSetFont(-1, $f_small)
	GUICtrlCreateGroup("Copy CHDK binaries to Card", R(280), R(20), R(250), R(50) )
	$mbut_down_bin = GUICtrlCreateButton("Download CHDK", R(290), R(40), R(90), R(22) )
	$mbut_copy_bin = GUICtrlCreateButton("CHDK->Card", R(385), R(40), R(70), R(22) )
	GUICtrlSetState(-1, $GUI_DISABLE)
	$chk_bin_over = GUICtrlCreateCheckbox("Overwrite", R(460), R(43), R(68), R(18))
	; -------------------------------------------------------------------------------
	GUICtrlCreateGroup("CHDK Folder Operations", R(280), R(80), R(250), R(120) )
	$mbut_copy_2cust = GUICtrlCreateButton("CHDK -> Custom", R(290), R(100), R(110), R(22) )
	GUICtrlSetState(-1, $GUI_DISABLE)
	$mbut_copy_2card = GUICtrlCreateButton("Custom -> CHDK", R(405), R(100), R(115), R(22) )
	GUICtrlSetState(-1, $GUI_DISABLE)

	$mbut_sel_cust = GUICtrlCreateButton("Select", R(290), R(128), R(40), R(22) )
	GUICtrlSetState(-1, $GUI_DISABLE)
	$custom_path = IniRead($inifile, "Card", "custom_path", $subdir & "\Custom")
	$lab_cust_path = GUICtrlCreateLabel($custom_path, R(335), R(132), R(190), R(37) )
	$mbut_chdk_cfg = GUICtrlCreateButton("Save CCHDK.CFG", R(290), R(170), R(110), R(22) )
	GUICtrlSetState(-1, $GUI_DISABLE)
	$mbut_chdk_show = GUICtrlCreateButton("Load CCHDK.CFG", R(405), R(170), R(115), R(22) )
	GUICtrlSetState(-1, $GUI_DISABLE)

	GUICtrlCreateGroup("Note: All settings will be saved to ini file", R(280), R(210), R(250), R(95) )

	$chk_stop_info =  GUICtrlCreateCheckbox("Stop info messages", R(300), R(230), R(110), R(18) )
	$chk_notooltips = GUICtrlCreateCheckbox("Stop tooltips", R(430), R(230), R(90), R(18) )
	$chk_fix_disk =   GUICtrlCreateCheckbox("Allow fixed disks", R(300), R(252), R(100), R(18) )
	$chk_CF =         GUICtrlCreateCheckbox("CF boot sector", R(430), R(252), R(90), R(18) )

	$mbut_credits = GUICtrlCreateButton("About / Credits", R(290), R(275), R(90), R(22) )
	$mbut_go_back = GUICtrlCreateButton("Exit ( or press Esc )", R(385), R(275), R(135), R(22) )

	ReadSett($chk_stop_info, "Program", "chk_stop_info")
	ReadSett($chk_notooltips, "Program", "chk_notooltips")
	ReadSett($chk_bin_over, "Card", "chk_bin_over")
	ReadSett($chk_fix_disk, "Card", "chk_fix_disk")
	ReadSett($chk_auto_sel, "Card", "chk_auto_sel")
	ReadSett($chk_CF, "Card", "chk_CF")
	ReadSett($chk_auto_sel, "Card", "chk_auto_sel", 1)

	GUISetState()

	CardToolTips()
	CardBootSector()
	WriteXY()
	WinSetTitle($cardmenu, "", 	$Title & _
								" [" & $wpos[2] & "x" & $wpos[3] & ", siz/fnt=" & $w_scaler*100 & "/" & $f_scaler*100 & "%]")

	If IsChecked($chk_auto_sel) Then $redraw = 1
	If $card_drive <> "" Then $redraw = 2

	While 1
		$cmsg = GUIGetMsg()
		If $redraw > 0 Then $cmsg = $card_pic
		Switch $cmsg
			Case $GUI_EVENT_CLOSE
				ExitLoop
			Case $mbut_go_back
				ExitLoop
			Case $mbut_credits
				MsgBox(0, $Title,	"Just a small card tool for CHDK fans" & @CRLF & _
									"Uses the incredible Universal Dumper," & @CRLF & _
									"thanks ewavr, Jeff666, mx3, RyeBrye," & @CRLF & _
									"chr, brake and ma_jk" & @CRLF & _
									"and ewavr's bootable.exe (with small" & @CRLF & _
									"mods to also return bootstatus flags)." & @CRLF & @CRLF & _
									"Program will dump source codes and" & @CRLF & _
									"helper files in a subdir with it's own" & @CRLF & _
									"name, including the GPL COPYING" & @CRLF & @CRLF & _
									"New in 1.45:" & @CRLF & _
									"- also makes FAT32 CF's bootable" & @CRLF & @CRLF & _
									"New since 1.0:" & @CRLF & _
									"- will now (FAT32)format cards > 4 GB" & @CRLF & _
									"- fixed drive override" & @CRLF & _
									"- added some tooltips" & @CRLF & _
									"- switch off messages (exc. errors)")
			Case $mbut_resizer
				WriteXY()
				SetSize()
				ShowCardMenu()
				ExitLoop
			Case $chk_stop_info
				SaveSett($chk_stop_info, "Program", "chk_stop_info")
			Case $chk_notooltips
				CardToolTips()
			Case $chk_CF
				$redraw = CardBootSector()
			Case $mbut_form_fat
				$redraw = CardFormat($card_drive, "CANON_DC")
			Case $mbut_mkboot
				$redraw = CardMakeBoot($card_drive)
			Case $mbut_udump_newdry
				$redraw = CardMakeUdumper("newdryos.bin", $card_drive)
			Case $mbut_udump_dry
				$redraw = CardMakeUdumper("dryos.bin", $card_drive)
			Case $mbut_udump_vxw
				$redraw = CardMakeUdumper("vxworks.bin", $card_drive)
			Case $mbut_udump_analyse
				CardCleanDump()
			Case $mbut_udump_show
				DosExec('bintext.exe ' & $card_drive & 'empty.dum' , $subdir)
			Case $mbut_down_bin
				ShellExecute("http://mighty-hoernsche.de")
			Case $mbut_copy_bin
				GUICtrlSetState($mbut_copy_bin, $GUI_DISABLE)
				$last_copy_path = IniRead($inifile, "Card", "last_copy_path", "::{450D8FBA-AD25-11D0-98A8-0800361B1103}")

				$ret = FileOpenDialog(	"Choose the proper ZIP file for your camera/firmware", _
										$last_copy_path, "Zip files (*.zip)", 3  )
				If $ret <> "" Then
					SplashTextOn("", 'Unzipping to ' & $card_drive & ' ...', 300, 40, $wpos[0] + R(275) - 150, $wpos[1] + R(160) - 20, 33)
					SaveSett($chk_bin_over, "Card", "chk_bin_over")
					If IsChecked($chk_bin_over) Then
						$flag = '-o '
					Else
						$flag = '-n '
					EndIf
					DosExec('unzip.exe ' & $flag & '"' & $ret & '"' & ' -d ' & $card_drive , $subdir)
					SplashOff()
					DriveSetLabel($card_drive, "CANON_DC")
					Do
						$ret = StringTrimRight($ret, 1)
					Until StringRight($ret, 1) = "\"
					$last_copy_path = StringTrimRight($ret, 1)
					$redraw = 2
				EndIf
				IniWrite($inifile, "Card", "last_copy_path", $last_copy_path)
				GUICtrlSetState($mbut_copy_bin, $GUI_ENABLE)
			Case $mbut_copy_2card
				If FileExists($card_drive & "CHDK\CCHDK.CFG") Then
					FileMove($card_drive & "CHDK\CCHDK.CFG", $card_drive & "CHDK\CCHDK.BAK", 1)
				EndIf
				SplashTextOn("", "Copying " & $custom_path & " to " & $card_drive & "CHDK ...", 300, 40, $wpos[0] + R(275) - 150, $wpos[1] + R(160) - 20, 33)
				DirCopy($custom_path, $card_drive & "CHDK", 1)
				SplashOff()
				$redraw = 2
			Case $mbut_copy_2cust
				SplashTextOn("", "Copying " & $card_drive & "CHDK to " & $custom_path & " ...", 300, 40, $wpos[0] + R(275) - 150, $wpos[1] + R(160) - 20, 33)
				DirCopy($card_drive & "CHDK", $custom_path, 1)
				SplashOff()
				$redraw = 2
			Case $mbut_sel_cust
				If $custom_path = $here & "\Custom" And Not FileExists($custom_path) Then
					DirCreate($custom_path)
					MsgBox(0, "Custom Folder",	"This appears to be the first time that" & @CRLF & _
												"you use this option. For your convenience," & @CRLF & _
												"the folder " & $custom_path & " has" & @CRLF & _
												"been created and is preselected. You can" & @CRLF & _
												"of course change this" )
				EndIf
				$ret = FileSelectFolder("Select CHDK Custom folder. ALL CONTENT" & @CRLF & _
										"here will be copied to <card>\CHDK" & @CRLF & _
										"and vice versa when pressing the buttons" & @CRLF & _
										"'Custom->CHDK' && 'CHDK->Custom', respectively", StringLeft($here, 3), 7, $custom_path)
				If $ret <> "" Then
					$custom_path = $ret
					IniWrite($inifile, "Card", "custom_path", $custom_path)
					$redraw = 2
				EndIf
			Case $mbut_chdk_cfg
				$dummy = $subdir & "\CFGS\" & @YEAR & @MON & @MDAY & "@" & @HOUR & @MIN & ".CFG"
				$ret = InputBox("Save CCHDK.CFG from Card", "The file will be saved as " & $dummy & _
								"; type a tag below, if you want one. Name and tag will be kept " & _
								"in " & $subdir & "\CFGS\CCHDK_CFG.INI", "", "", 400, 150)
				If @error <> 1 Then
					SplashTextOn("", "Copying " & $card_drive & "CHDK\CCHDK.CFG" & " ...", 300, 40, $wpos[0] + R(275) - 150, $wpos[1] + R(160) - 20, 33)
					FileCopy($card_drive & "CHDK\CCHDK.CFG", $dummy, 8)	; 8 creates path if needed
					SplashTextOn("", "Adding tag to " & $subdir & "\CFGS\CCHDK_CFG.INI" & " ...", 300, 40, $wpos[0] + R(275) - 150, $wpos[1] + R(160) - 20, 33)
					IniWrite($subdir & "\CFGS\CCHDK_CFG.INI", "CCHDK_CFG", @YEAR & @MON & @MDAY & "@" & @HOUR & @MIN & ".CFG", $ret)
					GUICtrlSetState($mbut_chdk_show, $GUI_ENABLE)
					SplashOff()
				EndIf
			Case $mbut_chdk_show
				ShellExecute("notepad.exe", $subdir & "\CFGS\CCHDK_CFG.INI", $here)
				WinActivate($cardmenu)
				$ret = FileOpenDialog("Select CFG to restore to Card", $subdir & "\CFGS", "Config (*.CFG)", 1)
				If Not @error = 1 And $ret <> "" Then
					If FileExists($card_drive & "CHDK\CCHDK.CFG") Then
						FileMove($card_drive & "CHDK\CCHDK.CFG", $card_drive & "CHDK\CCHDK.BAK", 1)
					EndIf
					FileCopy($ret, $card_drive & "CHDK\CCHDK.CFG", 9) ; overwrite + creates path if not present
				EndIf
				WinClose("CCHDK_CFG.INI", "")
			Case $card_pic
				If $redraw < 2 Then
					GUICtrlSetState($mbut_form_fat, $GUI_DISABLE)
					Do
						$card_drive = FileSelectFolder(	"Select SD/CF Card drive - Note that only 'Removable' or" & @CRLF & _
														"'Unknown' (and 'Fixed' if selected) drive types will be" & @CRLF & _
														"accepted; select Cancel if no drive selectable.", _
														"::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", 2, "", $cardmenu )
						If $card_drive = "" Then ExitLoop
						$card_drive = StringLeft($card_drive, 3)	; ignore selected subdir
						Switch DriveGetType($card_drive)
							Case "Removable", "Unknown"
								$acceptable = True
							Case "Fixed"
								If IsChecked($chk_fix_disk) Then
									$acceptable = True
								Else
									$acceptable = False
								EndIf
							Case Else
								$acceptable = False
						EndSwitch
					Until ( StringInStr($illegal, StringLeft($card_drive, 1)) = 0 ) And  $acceptable
				EndIf
				SaveSett($chk_fix_disk, "Card", "chk_fix_disk")
				If $card_drive <> "" Then
					GUICtrlSetState($mbut_show, $GUI_ENABLE)
					GUICtrlSetState($mbut_form_fat, $GUI_ENABLE)
					GUICtrlSetData($lab_card_drv, $card_drive)
					GUICtrlSetData($lab_card_typ, DriveGetType($card_drive))
					If DriveGetType($card_drive) = "Fixed" Then GUICtrlSetColor($lab_card_typ, 0xFF0000)
					$card_fs = DriveGetFileSystem($card_drive)
					GUICtrlSetData($lab_card_fs, $card_fs)
					GUICtrlSetData($lab_card_lab, DriveGetLabel($card_drive))
					$card_sz = DriveSpaceTotal($card_drive)
					GUICtrlSetData($lab_card_siz, Round($card_sz, 1) & " MB  (" & Round(DriveSpaceFree($card_drive), 1) & " MB free)")
					GUICtrlSetData($lab_cust_path, $custom_path)
					GUICtrlSetState($mbut_sel_cust, $GUI_ENABLE)
					$bootstate = DosExec("echo r | bootable.exe " & StringLeft($card_drive, 2), $subdir)
					$bootstateCF = DosExec("echo r | bootableCF.exe " & StringLeft($card_drive, 2), $subdir)
					$bootstateCF32 = DosExec("echo r | bootableCF32.exe " & StringLeft($card_drive, 2), $subdir)
					If $card_sz <= 4096 Then
						GUICtrlSetState($mbut_udump_dry, $GUI_ENABLE)
						GUICtrlSetState($mbut_udump_newdry, $GUI_ENABLE)
						GUICtrlSetState($mbut_udump_vxw, $GUI_ENABLE)
						GUICtrlSetData($mbut_form_fat, "Format as FAT")
						If $card_fs = "FAT" Then
							GUICtrlSetState($mbut_copy_bin, $GUI_ENABLE)
							If IsChecked($chk_CF) Then
								Switch $bootstate
									Case 4
										If $bootstateCF = 4 Then
											GUICtrlSetData($lab_card_boot, "ON [CF boot ON]")
										Else
											GUICtrlSetData($lab_card_boot, "ON [CF boot OFF]")
										EndIf
										GUICtrlSetState($mbut_mkboot, $GUI_DISABLE)
									Case 5
										GUICtrlSetData($lab_card_boot, "OFF [CF boot OFF]")
										GUICtrlSetState($mbut_mkboot, $GUI_ENABLE)
									Case 3
										CardReadError()
								EndSwitch
							Else
								Switch $bootstate
									Case 4
										GUICtrlSetData($lab_card_boot, "ON ['BOOTDISK']")
										GUICtrlSetState($mbut_mkboot, $GUI_DISABLE)
									Case 5
										GUICtrlSetData($lab_card_boot, "OFF [no'BOOTDISK']")
										GUICtrlSetState($mbut_mkboot, $GUI_ENABLE)
									Case 3
										CardReadError()
								EndSwitch
							EndIf
						EndIf
						If $card_fs = "FAT32" Then
							If IsChecked($chk_CF) Then
								GUICtrlSetState($mbut_copy_bin, $GUI_ENABLE)
								Switch $bootstateCF32
									Case 4
										GUICtrlSetData($lab_card_boot, "OFF [CF boot ON]")
										GUICtrlSetState($mbut_mkboot, $GUI_DISABLE)
									Case 5
										GUICtrlSetData($lab_card_boot, "OFF [CF boot OFF]")
										GUICtrlSetState($mbut_mkboot, $GUI_ENABLE)
									Case 3
										CardReadError()
								EndSwitch
							Else
								GUICtrlSetState($mbut_copy_bin, $GUI_DISABLE)
								GUICtrlSetState($mbut_mkboot, $GUI_DISABLE)
								GUICtrlSetData($lab_card_boot, "OFF [can't boot FAT32!]")
							EndIf
						EndIf
					EndIf
					If $card_sz > 4096 Then
						GUICtrlSetData($mbut_form_fat, "Format as FAT32")
						GUICtrlSetState($mbut_udump_dry, $GUI_DISABLE)
						GUICtrlSetState($mbut_udump_newdry, $GUI_DISABLE)
						GUICtrlSetState($mbut_udump_vxw, $GUI_DISABLE)
						If IsChecked($chk_CF) Then
							GUICtrlSetState($mbut_copy_bin, $GUI_ENABLE)
							Switch $bootstateCF32
								Case 4
									GUICtrlSetData($lab_card_boot, "OFF [CF boot ON]")
									GUICtrlSetState($mbut_mkboot, $GUI_DISABLE)
								Case 5
									GUICtrlSetData($lab_card_boot, "OFF [CF boot OFF]")
									GUICtrlSetState($mbut_mkboot, $GUI_ENABLE)
								Case 3
									CardReadError()
							EndSwitch
						Else
							GUICtrlSetState($mbut_copy_bin, $GUI_DISABLE)
							GUICtrlSetData($lab_card_boot, "OFF [can't boot FAT32!]")
						EndIf
					EndIf
					;------------------------------------------------------------
					If $card_fs = "FAT" Or $card_fs = "FAT32" Then
						GUICtrlSetState($mbut_copy_2cust, $GUI_ENABLE)
						GUICtrlSetState($mbut_copy_2card, $GUI_ENABLE)
					Else
						GUICtrlSetState($mbut_copy_2cust, $GUI_DISABLE)
						GUICtrlSetState($mbut_copy_2card, $GUI_DISABLE)
					EndIf

					If FileExists($card_drive & "empty.dum") Then
						GUICtrlSetState($mbut_udump_show, $GUI_ENABLE)
						GUICtrlSetState($mbut_udump_analyse, $GUI_ENABLE)
					Else
						GUICtrlSetState($mbut_udump_show, $GUI_DISABLE)
						GUICtrlSetState($mbut_udump_analyse, $GUI_DISABLE)
					EndIf

					If FileExists($card_drive & "CHDK\CCHDK.CFG") Then
						GUICtrlSetState($mbut_chdk_cfg, $GUI_ENABLE)
					Else
						GUICtrlSetState($mbut_chdk_cfg, $GUI_DISABLE)
					EndIf

					If FileExists($subdir & "\CFGS\CCHDK_CFG.INI") Then
						GUICtrlSetState($mbut_chdk_show, $GUI_ENABLE)
					Else
						GUICtrlSetState($mbut_chdk_show, $GUI_DISABLE)
					EndIf
				EndIf
				$redraw = 0
			Case $mbut_show
				ShellExecute("explorer.exe", $card_drive, $card_drive)
		EndSwitch
	WEnd
	WriteXY()
	IniWrite($inifile, "Card", "custom_path", $custom_path)
	SaveSett($chk_bin_over, "Card", "chk_bin_over")
	SaveSett($chk_fix_disk, "Card", "chk_fix_disk")
	SaveSett($chk_stop_info, "Program", "chk_stop_info")
	SaveSett($chk_auto_sel, "Card", "chk_auto_sel")
EndFunc

Func CardMakeUdumper($bin, $drive)
	Local $ret

	If DriveSpaceTotal($drive) < 11 Then
		MsgBox(0, "Card too small ", "Please use a card with 16 Mb or more ...")
		Return 0
	EndIf
	If Not IsChecked($chk_stop_info) Then
		$ret = 	MsgBox(1, 	"This is " & $subdir & "\udumper.txt", $ud_txt & @CRLF & @CRLF & _
							"          <<<< Click OK to start preparing the card, or Cancel to abort >>>>" )
		If $ret = 2 Then Return 0
	EndIf
	$ret = CardFormat( $drive, "UD_" & StringUpper(StringTrimRight($bin, 4)) )
	If $ret = 0 Then Return 0
	SplashTextOn("", "Copying UDUMPER to " & $drive & " ...", 220, 40, $wpos[0] + R(275) - 110, $wpos[1] + R(160) - 20, 33)
	; assure 'empty.bin' gets written first ...
	DosExec('unzip.exe -o empty2.zip -d ' & $drive , $subdir)
	; ... then write all udumper binaries to card ...
	DosExec('unzip.exe -o udumpfull2.zip -d ' & $drive , $subdir)
	; ... and rename the appropiate 1 to 'DISKBOOT.BIN'
	FileCopy($drive & $bin, $drive & "DISKBOOT.BIN")
	;FileCopy(@ScriptFullPath, $drive)
	SplashOff()
	Return CardMakeBoot($drive)
EndFunc

Func CardFormat($drive, $label)
	Local $ret, $type, $cmd, $warn = ""

	; check for photo/video on card
	If DosExec("dir " & $drive & "*.JPG /S") = 0 Then $warn &= " JPG"
	If DosExec("dir " & $drive & "*.CRW /S") = 0 Then $warn &= " CRW"
	If DosExec("dir " & $drive & "*.AVI /S") = 0 Then $warn &= " AVI"
	If $warn <> "" Then $warn = "Attention! Card " & $drive & " contains:" & $warn & @CRLF & @CRLF

	If ( $warn <> "" ) Or ( Not IsChecked($chk_stop_info) ) Then
		$ret = MsgBox(1,"Warning", $warn & _
						"Formatting will DESTROY ALL DATA on card " & $drive & @CRLF & @CRLF & _
						"Are you sure you want to continue ?" )
		If $ret = 2 Then Return 0
	EndIf
	If DriveSpaceTotal($drive) > 4096 Then
		$type = " as FAT32"
		$cmd = " /FS:FAT32"
		$label = ""
		If Not IsChecked($chk_stop_info) Then
			MsgBox(0, "Warning", _
				"Your card needs to be formatted with the FAT32" & @CRLF & _
				"file system. CHDK can not start from this card," & @CRLF & _
				"and 'CHDK->Card' option has been disabled." )
		EndIf
	Else
		If DriveSpaceTotal($drive) > 2048 Then
			If Not IsChecked($chk_stop_info) Then
				MsgBox(0, "Warning", _
					"Your card needs to be FAT formatted with (non-standard)" & @CRLF & _
					"64 KB clusters. No CHDK problems have been reported so" & @CRLF & _
					"far, but try a smaller (max. 2 GB) if you suspect any." )
			EndIf
		EndIf
		$type = " as FAT16"
		$cmd = " /FS:FAT"
	EndIf
	SplashTextOn("", "Formatting Card " & $drive & $type & " ...", 250, 40, $wpos[0] + R(275) - 125, $wpos[1] + R(160) - 20, 33)
	$ret = DosExec("echo | format " & StringLeft($drive, 2) & $cmd & " /V:" & $label & " /X")
	SplashOff()
	If $ret <> 0 Then
		CardWriteError()
		Return 0
	Else
		If $label = "CANON_DC" Then
			$ret = MsgBox(4,"Option", _
							"Do you want 'ver.req' and 'vers.req' to be written to" & @CRLF & _
							"the card ?  It allows you to check the REAL firmware" & @CRLF & _
							"version by pressing DISP while HOLDING DOWN Func/Set" )
			If $ret <> 6 Then Return 2
			FileWrite($drive & "ver.req", "")
			FileWrite($drive & "vers.req", "")
		EndIf
		Return 2
	EndIf
EndFunc


Func CardMakeBoot($drive)
	Local $ret, $prg = "bootable.exe"

	If IsChecked($chk_CF) Then
		If $card_fs = "FAT32" Then
			$prg = "bootableCF32.exe"
		Else
			$prg = "bootableCF.exe"
		EndIf
	EndIf



	SplashTextOn("", "Making Card " & $drive & " bootable ...", 180, 40, -1, $wpos[0] + R(275) - 90, $wpos[1] + R(160) - 20, 33)
	$ret = DosExec("echo w | " & $prg & " " & StringLeft($drive, 2), $subdir)
	If $ret = 3 Then
		CardWriteError()
		SplashOff()
		Return 0
	Else
		SplashOff()
		If Not IsChecked($chk_stop_info) Then
			If IsChecked($chk_CF) Then
				MsgBox(0, "Note", 	"Card is now bootable in Canon cams." & @CRLF & _
									"'EOS_DEVELOP' and 'BOOTDISK' have" & @CRLF & _
									"been written to 0x24 and 0x40 for" & @CRLF & _
									"FAT16 and 0x47 and 0x5C for FAT32" )
			Else
				MsgBox(0, "Note", 	"Card is now bootable in Canon cams." & @CRLF & _
									"Do not forget to set Write Protect" & @CRLF & _
									"on the card (slide tab up, away from" & @CRLF & _
									"the electric connectors) to take" & @CRLF & _
									"advantage of this feature.")
			EndIf
		EndIf
		Return 2
	EndIf
EndFunc

Func CardWriteError()
	MsgBox(0, "Error",	"Could not write to the Card !" & @CRLF & _
						"Please check write protect tab." )
EndFunc

Func CardReadError()
	MsgBox(0, "Error",	"Could not read from the Card !" & @CRLF & _
						"Please check if card was removed from reader." & @CRLF & _
						"If not, check if Windows recognizes it.")
EndFunc
; --------------------------------------------
Func CardCleanDump()
	Local $infile, $outfile, $tempfile, $hnd_in, $hnd_out, $long, $trailing_zeros = -1, $pos, $blob
	Local $i, $orgsize, $newname, $cleantext = "Cleaning firmware dump"

	$infile = $card_drive & "empty.dum"

	$orgsize = FileGetSize($infile)
	$tempfile = $subdir & "\stripped.tmp"
	$outfile = $subdir & "\stripped.bin"
	$hnd_in = FileOpen($infile, 16)	; open for binary read
	If $hnd_in = -1 Then
		CardReadError()
		Return
	EndIf
	SplashTextOn($cleantext, "Scanning your dump ...", 200, 50, $wpos[0] + R(275) - 100, $wpos[1] + R(160) - 25, 32)
	$pos = 0
	Do
		$long = FileRead($hnd_in, 4)
		$i = @error
		$pos += 4
	Until $long <> 0x00000000 Or $i = -1
	SplashOff()
	If $i = -1 Then
		FileClose($hnd_in)
		MsgBox(0, "No Data", "This dump contains no valid data !")
		Return
	EndIf

	$hnd_out = FileOpen($tempfile, 18)	; open for binary write
	FileWrite($hnd_out,	$long)			; write first non-zero longword
	SplashTextOn($cleantext, "Trimming " & $pos - 4 & " Leading 00's ...", 280, 50, $wpos[0] + R(275) - 140, $wpos[1] + R(160) - 25, 32)
	While 1
		$long = FileRead($hnd_in, 4)
		If @error = -1 Then ExitLoop
		If $long = 0x00000000  Then
			If $trailing_zeros = -1 Then
				$trailing_zeros = $pos
			EndIf
		Else
			$trailing_zeros = -1
		EndIf
		$pos += 4
		FileWrite($hnd_out, $long)
	WEnd
	SplashOff()
	FileClose($hnd_in)
	FileClose($hnd_out)

	; now we must recalculate the $trailing_zeros offset for the temp file (because it had its' leading 0's trimmed)
	$trailing_zeros -= ($orgsize - FileGetSize($tempfile))

	$hnd_in = FileOpen($tempfile, 16)	; for bin. read
	$hnd_out = FileOpen($outfile, 18)	; for bin. write

	SplashTextOn($cleantext, "Trimming " & ($orgsize - $trailing_zeros) & " Trailing 00's ...", _
										280, 50, $wpos[0] + R(275) - 140, $wpos[1] + R(160) - 25, 32	)
	$pos = 0
	Do
		$long = FileRead($hnd_in, 4)
		If @error = -1 Then ExitLoop	; should never be reached
		$pos += 4
		FileWrite($hnd_out, $long)
	Until $pos = $trailing_zeros
	SplashOff()
	FileClose($hnd_in)
	FileClose($hnd_out)
	FileDelete($tempfile)
	$orgsize = FileGetSize($outfile)	; get outfile's size
	FileMove($outfile, $outfile & ".org")
	$hnd_in = FileOpen($outfile & ".org", 16)	; open for binary read
	$hnd_out = FileOpen($outfile, 18)			; for bin. write
	$blob = FileRead($hnd_in, $orgsize - 2)		; read all but the last 2 bytes ...
	FileWrite($hnd_out, $blob)					; ... and write them back
	FileClose($hnd_in)
	FileClose($hnd_out)
	FileDelete($outfile & ".org")
	$newname = FileSaveDialog(	"Done, please rename stripped.bin (ex. PRIMARY_A620-100f.bin)", $subdir, _
								"Binary Files (*.bin)", 16, "PRIMARY_cam-firm.bin", $cardmenu	)
	If $newname <> "" Then
		If FileExists($newname) Then FileDelete($newname)
		FileMove($outfile, $newname)
	EndIf
	FileChangeDir($here)
	Return
EndFunc
; --------------------------------------------
Func CardBootSector()

	SaveSett($chk_CF, "Card", "chk_CF")

	If $card_drive = "" Then Return 1	; force redraw, selection & read
	Return 2	; force redraw & read
EndFunc
; --------------------------------------------
Func CardToolTips()

	SaveSett($chk_notooltips, "Program", "chk_notooltips")

	If Not IsChecked($chk_notooltips) Then
		GUICtrlSetTip($chk_auto_sel, "Select Card at program start", $tt, 1)
		GUICtrlSetTip($card_pic, "Select card to work with", $tt, 1)
		GUICtrlSetTip($mbut_show, "Show card contents", $tt, 1)
		GUICtrlSetTip($mbut_form_fat, 	"Formats your card and writes 'ver.req' to it, so that" & @CRLF & _
										"it is able show your cam's firmware version." & @CRLF & _
										"(Button shows 'Format as FAT32' for cards > 4 GB !)", $tt, 1)
		GUICtrlSetTip($mbut_mkboot, "Writes 'BOOTDISK' to the cards' bootsector" & @CRLF & _
									"to allow Canon cams to boot from it.  Note:" & @CRLF & _
									"For SD cards: this works on FAT only (NOT FAT32)" & @CRLF & _
									"For CF cards: this works on BOTH FAT and FAT32", $tt, 1)
		GUICtrlSetTip($mbut_udump_newdry, $ud_tip, $tt, 1)
		GUICtrlSetTip($mbut_udump_dry, $ud_tip, $tt, 1)
		GUICtrlSetTip($mbut_udump_vxw, $ud_tip, $tt, 1)
		GUICtrlSetTip($mbut_udump_show, "Shows you all strings found in" & @CRLF & _
										"'empty.dum' on the current card", $tt, 1)
		GUICtrlSetTip($mbut_udump_analyse, 	"Analyses your dump. If it is OK, a clean copy" & @CRLF & _
											"(leading/trailing zeros stripped) will be made:" & @CRLF & _
											$subdir & "\stripped.bin", $tt, 1)
		GUICtrlSetTip($mbut_down_bin,	"Opens the CHDK AutoBuild web page" & @CRLF & _
										"in your default browser", $tt, 1)
		GUICtrlSetTip($mbut_copy_bin,	"Select a ZIP archive with binaries for" & @CRLF & _
										"your camera/firmware and unzip to card", $tt, 1)
		GUICtrlSetTip($mbut_copy_2cust,	"Copy entire contents of CHDK folder on" & @CRLF & _
										"card to a user-defined folder", $tt, 1)
		GUICtrlSetTip($mbut_copy_2card,	"Copy entire contents of a user-defined" & @CRLF & _
										"folder to CHDK folder on card. CCHDK.CFG" & @CRLF & _
										"on card will be renamed to CCHDK.BAK", $tt, 1)
		GUICtrlSetTip($mbut_chdk_cfg, 	"Make time/date stamped backup and store" & @CRLF & _
										"in dedicated folder; allows adding tags" & @CRLF & _
										"of up to 250 chars, no linefeeds though", $tt, 1)
		GUICtrlSetTip($mbut_chdk_show, 	"Shows your CCHDK.CFG backup collection in" & @CRLF & _
										"Notepad and lets you select one. CCHDK.CFG" & @CRLF & _
										"on card will be renamed to CCHDK.BAK", $tt, 1)
		GUICtrlSetTip($chk_stop_info, 	"Will stop Info message boxes that might" & @CRLF & _
										"start to irritate you after a while ;)", $tt, 1)
		GUICtrlSetTip($chk_notooltips, 	"Will stop this tooltip and any other, when" & @CRLF & _
										"they start to irritate you after a while ;)", $tt, 1)
		GUICtrlSetTip($chk_fix_disk, 	"The following fixed drives will NEVER be accepted:" & @CRLF & _
										"SystemDrive, HomeDrive, and the drive containing" & @CRLF & _
										"this program (if a fixed drive !)", $tt, 1)
		GUICtrlSetTip($chk_CF, 			"When making the drive bootable, this will write both" & @CRLF & _
										"EOS_DEVELOP @ 0x2B and BOOTDISK @ 0x40 to the MBR" & @CRLF & _
										"(should work with P&S, but only useful for DSLR cams)" & @CRLF & _
										"For CF on FAT32, offsets 0x47 and 0x5C are used.", $tt, 1)
		GUICtrlSetTip($mbut_resizer,	"Lets you adjust window and font", $tt, 1)
	Else
		GUICtrlSetTip($chk_auto_sel, "")
		GUICtrlSetTip($card_pic, "")
		GUICtrlSetTip($mbut_show, "")
		GUICtrlSetTip($mbut_form_fat, "")
		GUICtrlSetTip($mbut_mkboot, "")
		GUICtrlSetTip($mbut_udump_newdry, "")
		GUICtrlSetTip($mbut_udump_dry, "")
		GUICtrlSetTip($mbut_udump_vxw, "")
		GUICtrlSetTip($mbut_udump_show, "")
		GUICtrlSetTip($mbut_udump_analyse, "")
		GUICtrlSetTip($mbut_down_bin, "")
		GUICtrlSetTip($mbut_copy_bin, "")
		GUICtrlSetTip($mbut_copy_2cust,	"")
		GUICtrlSetTip($mbut_copy_2card,	"")
		GUICtrlSetTip($mbut_chdk_cfg, "")
		GUICtrlSetTip($mbut_chdk_show, "")
		GUICtrlSetTip($chk_stop_info, "")
		GUICtrlSetTip($chk_notooltips, "")
		GUICtrlSetTip($chk_fix_disk, "")
		GUICtrlSetTip($chk_CF, "")
		GUICtrlSetTip($mbut_resizer, "")
	EndIf

EndFunc

